; Scripts for the RealPlayerG2 and RealPlayer+G2
; created 02/15/1998 by Henter-Joyce Inc. 
 Include "hjconst.jsh"
Include "hjglobal.jsh"
include "realplay.jsm" 

Globals
int FirsttimerealPlayer, ; to give message first time only
int IsDialog

Void Function AutoStartEvent ()
let IsDialog=0

if (FirstTimeRealPlayer == 0) then
let FirstTimeRealPlayer = 1
if GetVerbosity() == 0 then
Delay(4) 
Say(msg1, ot_help) ; "Use Insert plus H for instructions running the Real player"
EndIf
endif ; first time entering this app
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow
	&& AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
	|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
		&& (RealWindow != FocusWindow)) then
		SayWindowTypeAndText (RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayFocusedWindow ()
if GetWindowSubtypeCode (GetParent (GetFocus ()))==18&&
GetWindowName (GetParent  (GetFocus ()))=="Setup of Realplayer G2" &&
IsDialog==0
then
Say(GetDialogStaticText (), ot_static)
SayWindow (FindDescendantWindow (GetParent (GetFocus ()), 65535), 0)
Say(GetDefaultButtonName (), ot_control_name)
Let IsDialog=1
elif GetWindowClass (GetParent (GetFocus ()))=="#32770" &&
IsDialog==0
then SayWindow (FindDescendantWindow (GetParent (GetFocus ()), 1009), 0)
Say(GetDefaultButtonName (), ot_control_name)
Let IsDialog=1
else
SayWindowTypeAndText (GlobalFocusWindow)
endif
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Real Player")
EndScript

Script HotKeyHelp ()
Say(msg14, ot_help) ; "Play or Pause = Control + P ",
Say(msg15, ot_help) ; "Stop = Control + S ",
Say(msg2 + GetScriptKeyName ("rewind"), ot_help) ; " Rewind = Control + Left Arrow ",
Say(msg3, ot_help) ; " Super Rewind = Control + Shift + Left Arrow",
Say(msg4 + GetScriptKeyName ("FastForward"), ot_help) ; " Fast Forward = Control + Right Arrow",
Say(msg5, ot_help) ; " Super Fast Forward = Control + Shift + Right Arrow",
Say(msg6 + GetScriptKeyName ("VolumeUp"), ot_help) ; "Volume up  = Control + Up Arrow",
Say(msg7 + GetScriptKeyName ("VolumeDown"), ot_help) ; "Volume down = Control + Down Arrow ",
Say(msg19, ot_help) ; "Previous Clip = Page Up ",
Say(msg20, ot_help) ; "Next Clip = Page Down"
Say(msg13, ot_help) ; "Search = Control + H",
Say(msg8, ot_help) ; "Open Location  = Control + L ",
Say(msg9, ot_help) ; " Open Local File = Control + O ",
Say(msg10 + GetScriptKeyName ("NormalView"), ot_help) ; "Normal View = Control + N",
Say(msg11 + GetScriptKeyName ("CompactView"), ot_help) ; "Compact View = Control + M ",
Say(msg16, ot_help) ; "Save Current Place (PlayerPlus only) = Control + Shift +A ",
Say(msg17, ot_help) ; "Record (PlayerPlus only) = Control + R",
Say(msg18, ot_help) ; "Help Contents = F1",
EndScript

Script ScreenSensitiveHelp ()
var
	int TheID,
	int TheType
let TheID = GetControlID (GetCurrentWindow())
let TheType = GetWindowtypeCode (GetCurrentWindow())

if  GetWindowClass (GetFocus ())=="PNGUIClass"
then	Say(msg21, ot_help) ; "This is the main application window for the RealPlayer"
Say(MSG22, ot_help) ; "Press insert+h to hear a list of the available hot keys"
elif GetWindowClass (GetParent (GetFocus ()))=="#32770"
then
Say(MSG27, ot_help)
say(msg28, ot_help)
else 
HotKeyHelpDefaultLoop ()
Endif 
EndScript

Script VolumeUp ()
if IsPCCursor () then
If(GetVerbosity() == 0) Then
Say(msg23, ot_message) ; "volume up"
endif 
{control+up arrow}
endif
EndScript

Script VolumeDown ()
if IsPCCursor () then
If(GetVerbosity() == 0) Then
Say(msg24, ot_message) ; "volume down"
endif
{control+down arrow}
endif
EndScript

Script rewind ()
if IsPCCursor () then
If(GetVerbosity() == 0) Then
Say(msg25, ot_message) ; "rewind",
endif
{control+left arrow}
endif 
EndScript

Script FastForward ()
if IsPCCursor () then
If(GetVerbosity() == 0) Then
Say(msg26, ot_message) ; "fast forward"
endif
{control+right arrow}
endif
EndScript

Script NormalView ()

Say(msg29, ot_message)
{control+n}
EndScript

Script CompactView ()
Say(msg30, ot_message)
{control+M}
EndScript
